unit ik121_unit1;

interface

uses
  ik121_baseunit,
  ik121_correct,
  ik121_infounit,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, DBCtrls,
  Buttons, MPlayer;

type
  THeidenhain = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    control: TMenuItem;
    Timer1: TTimer;
    Exit: TBitBtn;
    Init: TMenuItem;
    Adjust1: TMenuItem;
    Printer: TMenuItem;
    Timer2: TTimer;
    Timer3: TTimer;
    Image1: TImage;
    Exit1: TMenuItem;
    Info1: TMenuItem;

    procedure Timer1Timer(Sender: TObject);
    procedure InitClick(Sender: TObject);
    procedure ExitClick(Sender: TObject);
    procedure controlClick(Sender: TObject);
    procedure Adjust1Click(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure PrinterClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Heidenhain: THeidenhain;

implementation

uses
     ik121_unit2,
     ik121_unit3,
     display_unit1,
     adjust_unit,
     ik121_printer;

{$R *.DFM}
(*************************************************)
(*     100 ms Cycle Timer                        *)
(*     -> Display X,Y                            *)
(*************************************************)
procedure THeidenhain.Timer1Timer(Sender: TObject);
var
  data          : longint;
  x             : byte;
  refdone       : boolean;
  offset        : double;
begin
      for x:=0 to count^.axisnumber do
        begin
          Build_wert(count^.count[x]);
          build_status(count^.count[x]);
          (* Display axis *)
          Counter[x].xsign.caption:=count^.count[x]^.sign;
          Counter[x].xAnzeige.caption:=count^.count[x]^.value;
          Status:=IKStatus(x,@data);
          count^.count[x]^.status:=data;
          (* Ref. status *)
          Counter[x].ri_x_pan.Caption:=count^.count[x]^.refstatus;
          (* Min/Max status *)

          if count^.count[x].min then
            begin
              Counter[x].disp_x_min.show;
            end
          else
            begin
              Counter[x].disp_x_min.hide;
            end;
          if count^.count[x].max then
            begin
              Counter[x].disp_x_max.show;
            end
          else
            begin
              Counter[x].disp_x_max.hide;
            end;
          if count^.count[x].typ then
            begin
              Counter[x].disp_x_typ.show;
            end
          else
            begin
              Counter[x].disp_x_typ.hide;
            end;

          (* Coded Ref. marks *)
          if count^.count[x]^.refmark=coded then
            begin
              Status:=IKCodRef(x,@refdone,@offset);
              if refdone then
                begin
                  count^.count[x]^.offset:=offset;
                end;
            end;
        end;
end;
(*************************************************)
(* 1 s cycle timer                               *)
(* -> Status text (signal error)                 *)
(*************************************************)
procedure THeidenhain.Timer3Timer(Sender: TObject);
var
   x               : byte;
   estring         : string[20];
   buffer          : char;
   i               : byte;
begin
   for x:=0 to count^.axisnumber do
     begin
       estring:=count^.count[x]^.errorstring;
       Counter[x].x_error.Caption:=estring;
       buffer:=estring[1];
       for i:=1 to 15 do
         begin
           estring[i]:=estring[i+1];
         end;
       estring[15]:=buffer;
       count^.count[x]^.errorstring:=estring;
     end;
end;
(*************************************************)
(* 1 ms cycle timer                              *)
(* -> Position values                            *)
(*************************************************)
procedure THeidenhain.Timer2Timer(Sender: TObject);
var
     data   : longint;
     i,x,z  : byte;
     intp   : word;
     a,b    : double;
begin
      (* Store count values *)
      for x:=0 to count^.axisnumber do
        begin
          (* Latch values*)
          Status:=IKLatch(x,0);
          (* Poll status *)
          Status:=IKWaitLatch(x,0);

          (* Read AD converter values *)
          Status:=IKInputW(x,22,@data);
          count^.count[x]^.ad00:=data;
          Status:=IKInputW(x,24,@data);
          count^.count[x]^.ad90:=data;

          (* Read count values *)
          Status:=IKRead32(x,0,@data);
          count^.count[x].iwert:=data;

          (* If sample requested *)
          if ik_ad[x].samp_req then
            begin

              (* Clear counters *)
              if ik_ad[x].scount=0 then
                begin
                  for i:=0 to 7 do
                    begin
                      ik_ad[x].oktant[i].index:=0;
                    end;
                end;

              (* Sampling *)
              if ik_ad[x].scount<=N_Values then
                begin
                  intp:=data and $00000380;  (* i=oktant *)

                  (* Verschiebung der Oktanten-Samples *)

                  intp:=intp+(1024 div 16);
                  if intp>1023 then intp:=intp-1023;

                  intp:=intp shr 7;
                  i:=intp;
                  z:=ik_ad[x].oktant[i].index;
                  if z<=val_in_okt then
                    begin
                      (* Calculate range: +-1 *)
                      a:=(count^.count[x]^.ad00-512)/512;
                      b:=(count^.count[x]^.ad90-512)/512;
                      ik_ad[x].oktant[i].wert[z].dg00:=a;
                      ik_ad[x].oktant[i].wert[z].dg90:=b;
                      ik_ad[x].oktant[i].index:=z+1;
                      ik_ad[x].scount:=ik_ad[x].scount+1;
                    end;
                end
              else     (* Sample ready *)
                begin
                  Calc_q(x);
                  ik_ad[x].samp_rdy:=true;
                  ik_ad[x].scount:=0;
                end;
            end
          else
            begin
              ik_ad[x].samp_rdy:=false;
            end;
        end;
end;
(*************************************************)
(* Setup window                                  *)
(*************************************************)
procedure THeidenhain.InitClick(Sender: TObject);
begin
  rebuild_para(count);
  parameters.Show;
end;
(*************************************************)
(* Control window                                *)
(*************************************************)
procedure THeidenhain.controlClick(Sender: TObject);
begin
   rebuild_cntrl(count);
   controller.Show;
end;
(*************************************************)
(*************************************************)
procedure THeidenhain.PrinterClick(Sender: TObject);
begin
  rebuild_output(cprint);
  output.Show;
end;
(*************************************************)
(*************************************************)
procedure THeidenhain.Adjust1Click(Sender: TObject);
begin
  rebuild_draw(count);
  drawer.Show;
end;
(*************************************************)
(*************************************************)
procedure THeidenhain.ExitClick(Sender: TObject);
begin
  Application.Terminate;
end;
(*************************************************)
(*************************************************)
procedure THeidenhain.Exit1Click(Sender: TObject);
begin
  Application.Terminate;
end;
(*************************************************)
(*************************************************)
procedure THeidenhain.Info1Click(Sender: TObject);
begin
  info.Show;
end;
(*************************************************)
(*************************************************)
end.
